import type { RequestHandler } from 'express';

const handler: RequestHandler = async (req, res) => {
    try {
        const { body } =
            (await req.makeRequest<object>('https://suggest-maps.yandex.net/suggest-geo', {
                searchParams: {
                    callback: '',
                    search_type: 'addr',
                    v: 7, // версия выдачи
                    n: 5, // количество элементов
                    fullpath: 1,
                    lang: req.services.misc.lang,
                    part: req.body.part,
                },
                responseType: 'json',
                timeout: 8000,
            })) || {};
        return res.json({ status: 'ok', ...body });
    } catch (err) {
        return res.json({ status: 'error' });
    }
};

export default handler;
