import * as uuid from 'uuid';
import config from '../config';

import type { RequestHandler } from 'express';

const handler: RequestHandler = (req, res, next) => {
    if (config.environment !== 'dev' && config.environment !== 'testing') {
        Object.defineProperty(req, 'ip', {
            value: req.get('x-real-ip'),
        });
    }

    req.id = req.get('x-request-id') || uuid.v4().split('-').join('');
    req.ssrId = req.get('x-ssr-id') || uuid.v4().split('-').join('');
    res.set('x-request-id', req.id);

    return next();
};

export default handler;
