import type { RequestHandler } from 'express';

const yaOrigins = ['.yandex.ru', '.kinopoisk.ru'];

export const checkOrigin: RequestHandler = (req, res, next) => {
    const origin = String(req.query.origin);
    if (yaOrigins.some(yaOrigin => origin.endsWith(yaOrigin))) {
        res.locals.isYandexOrigin = true;
    }
    next();
};
