import type { RequestHandler } from 'express';

export const getUser: RequestHandler = (req, res, next) => {
    if (!res.locals.isYandexOrigin) {
        return next();
    }
    const { blackbox } = req;

    const users = (blackbox && blackbox.raw && 'users' in blackbox.raw && blackbox.raw.users) || [];

    if (!users.length) {
        return next();
    }

    const user = users.find(user => user.uid?.value === blackbox?.uid);

    if (!user) {
        return next();
    }

    const { public_id: publicId, display_name: { name = '', avatar: { default: avatar = '' } = {} } = {} } = user;

    res.locals.providerUser = { publicId, name, avatar };

    next();
};
