import type { RequestHandler } from 'express';

export const providerFetchList: RequestHandler = async (req, res, next) => {
    if (!res.locals.isYandexOrigin) {
        return next();
    }

    const {
        services: { documents },
        blackbox,
    } = req;

    const userId = Number(blackbox?.uid);

    if (!userId) {
        return next();
    }

    const { body } = await documents.getList({ userId });

    if (!body || !body.services) {
        return next();
    }

    res.locals.providerDocs = body;

    next();
};
