import React from 'react';
import serialize from 'serialize-javascript';
import reactCDN from '@yandex-int/react-static-version/dist/version';
import { Paranja, styles as paranjaStyles } from './Paranja';

import type { RenderProps } from '../../../../types';

type Props = {
    renderProps: RenderProps;
};

const renderNameMap = {
    bro: 'bro',
    suggest: 'suggest',
    provider: 'provider',
    embedded: 'iframe',
    popup: 'iframe',
};

const Html: React.FC<Props> = ({ children, renderProps }) => {
    const {
        assetsPath,
        constants,
        csrfToken,
        initialErrors,
        locals,
        meta,
        nonce,
        user,
        users,
        profiles,
    } = renderProps;
    const isBro = constants.type === 'bro';
    const isSuggest = constants.type === 'suggest';
    const renderName = renderNameMap[constants.type];
    const isRenderParanja = !isBro && !isSuggest;

    return (
        <html className={`${constants.theme}-theme`}>
            <head>
                <meta charSet="utf-8" />
                <meta
                    name="viewport"
                    content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, shrink-to-fit=no, viewport-fit=cover"
                />
                <meta httpEquiv="X-UA-Compatible" content="ie=edge" />
                <link rel="shortcut icon" href="/favicon.ico" />
                <link href={`${assetsPath}/style-${renderName}-render.css`} rel="stylesheet" />
                <title>{locals.common.title}</title>
                <script src={constants.dev ? reactCDN.development.reactWithDom : reactCDN.production.reactWithDom} />
                {isRenderParanja && <style dangerouslySetInnerHTML={{ __html: paranjaStyles }} />}
            </head>
            <body>
                {isRenderParanja ? (
                    <Paranja offset="small" align="top" isOverflowHidden={false} borderRadius={8}>
                        <div id="root">{children}</div>
                    </Paranja>
                ) : (
                    <div id="root">{children}</div>
                )}
            </body>
            <script
                nonce={nonce}
                dangerouslySetInnerHTML={{
                    __html: `
                        window.__CSRF__ = ${serialize(csrfToken)};
                        window.__LOCALS__ = ${serialize(locals)};
                        window.__META__ = ${serialize(meta)};
                        window.__USER__ = ${serialize(user)};
                        window.__PROFILES__ = ${serialize(profiles)};
                        window.__CONSTANTS__ = ${serialize(constants)};
                        window.__INITIAL_ERRORS__ = ${serialize(initialErrors)};
                        window.__USERS__ = ${serialize(users)};
                    `,
                }}
            />
            <script defer src={`${assetsPath}/${renderName}-render.js`} />
        </html>
    );
};

export default Html;
