import React from 'react';

// TODO добавить серверный рендеринг, убрать стили в *.css файл
export const styles = `
    .paranja {
        min-height: 100%;
        display: flex;
        box-sizing: border-box;

        opacity: 0;
        background-color: rgba(0, 0, 0, 0.2);

        transition: opacity 0.3s;
        
        overflow: auto;
    }

    .paranja_align_top {
        justify-content: center;
        align-items: flex-start;
    }

    .paranja_align_right {
        justify-content: flex-end;
        align-items: flex-start;
    }

    .paranja_align_center {
        justify-content: center;
        align-items: center;
    }

    .paranja_align_bottom {
        justify-content: center;
        align-items: flex-end;
    }

    .paranja_offset_small {
        padding: 10px;
    }

    .paranja_offset_big {
        padding: 24px;
    }

    .paranja_offset_none {
        padding: 0;
    }

    .paranja-content {
        position: relative;

        box-sizing: border-box;
        max-width: 424px;

        background-color: #fff;
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.2);

        transition: transform 0.2s;
        transform: scale(0.8);
    }

    .paranja-content_drawer {
        transform: scale(1);
        max-width: 100%;
        width: 100%;
        max-height: 0;
        transition: max-height 0.3s;
    }

    .paranja-content_overflow_hidden {
        overflow: hidden;
    }

    .paranja-content_border_radius_8 {
        border-radius: 8px;
    }

    .paranja-content_drawer.paranja-content_border_radius_8 {
        border-radius: 8px 8px 0 0;
    }

    .paranja-content_border_radius_32 {
        border-radius: 32px;
    }

    .paranja-content_drawer.paranja-content_border_radius_32 {
        border-radius: 32px 32px 0 0;
    }

    .visible .paranja {
        opacity: 1;
    }

    .visible .paranja-content {
        transform: scale(1);
    }

    .visible .paranja-content_drawer {
        max-height: calc(100vh - 20px);
    }

    .visible .paranja-blind-handler {
        height: 3px;
        width: 40px;
        background-color: #fff;
        margin: 8px auto;
        position: absolute;
        top: -19px;
        left: 0;
        right: 0;
        opacity: 0.3;
    }
`;

type ParanjaProps = {
    align: 'top' | 'right' | 'bottom' | 'center';
    offset: 'big' | 'small' | 'none';
    borderRadius: Number;
    isOverflowHidden?: boolean;
    isDrawer?: boolean;
};

export const Paranja: React.FC<ParanjaProps> = ({
    children,
    align,
    offset,
    isOverflowHidden,
    isDrawer,
    borderRadius,
}) => {
    return (
        <div className={['paranja', `paranja_align_${align}`, `paranja_offset_${offset}`].join(' ')}>
            <div
                className={[
                    'paranja-content',
                    `paranja-content_border_radius_${borderRadius}`,
                    isOverflowHidden && 'paranja-content_overflow_hidden',
                    isDrawer && 'paranja-content_drawer',
                ]
                    .filter(Boolean)
                    .join(' ')}
            >
                {isDrawer && (
                    <div className="paranja-blind-handler" />
                )}
                {children}
            </div>
        </div>
    );
};
