import React from 'react';
import { renderToStaticNodeStream } from 'react-dom/server';
import { filterProfilesByWhitelist } from '../../../../util';
import Html from './Html';

import type { Response } from 'express';
import type { RenderProps } from '../../../../types';

export const ssrRender = (res: Response, renderProps: RenderProps) => {
    const {
        meta: { whitelist },
        profiles,
        constants: { type },
    } = renderProps;
    const renderPropsPrepareProfile: RenderProps = {
        ...renderProps,
        profiles: ['bro', 'suggest'].includes(type) ? [] : filterProfilesByWhitelist(profiles, whitelist),
    };

    // TODO добавить серверный рендеринг приложения
    // <Html renderProps={renderProps} >
    //   <App />
    // </Html>

    return renderToStaticNodeStream(<Html renderProps={renderPropsPrepareProfile} />).pipe(res);
};
