import type { RequestHandler } from 'express';
import { checkOrigin } from './checkOrigin';
import { getUser } from './getUser';
import { renderSocial } from './render';

export const socialFinish: RequestHandler = async (req, res) => {
    const {
        query: { task_id: taskId, origin },
        services: { social },
    } = req;

    if (!origin || !taskId || typeof taskId !== 'string' || typeof origin !== 'string') {
        return res.end('bad_query');
    }

    if (!checkOrigin(origin)) {
        return res.end('bad_location');
    }

    if (!getUser(req)) {
        return renderSocial(req, res, { origin, result: { state: 'error', code: 'no_user' } });
    }

    const { body } = await social.getDataByTaskId(taskId);
    const { status, errors } = body || {};

    if (status === 'error' && errors) {
        return renderSocial(req, res, { origin, result: { state: 'error', data: errors } });
    }

    return renderSocial(req, res, { origin, result: { state: 'ok', data: body } });
};
