import React from 'react';
import serialize from 'serialize-javascript';
import { Request, Response } from 'express';
import { renderToStaticNodeStream } from 'react-dom/server';
import config from '../../config';

type Props = {
    origin: string;
    result: Object;
    nonce: string;
};

const Html: React.FC<Props> = ({ origin, result, nonce }) => {
    return (
        <html>
            <head />
            <body />
            <script
                nonce={nonce}
                dangerouslySetInnerHTML={{
                    __html: `
                        window.__ORIGIN__ = ${serialize(origin)};
                        window.__RESULT__ = ${serialize(result)};
                    `,
                }}
            />
            <script defer src={`${config.paths.assets}/social-render.js`} />
        </html>
    );
};

export const renderSocial = (req: Request, res: Response, { origin, result }: { origin: string; result: object }) => {
    res.set(
        'Content-Security-Policy',
        res.get('Content-Security-Policy').replace(" frame-ancestors 'none'; ", ` frame-ancestors ${origin}; `),
    );
    res.type('html');
    return renderToStaticNodeStream(<Html nonce={req.nonce} origin={origin} result={result} />).pipe(res);
};
