import type { RequestHandler } from 'express';
import { URL, URLSearchParams } from 'url';

import config from '../config';

const handler: RequestHandler = (req, res) => {
    const { blackbox } = req;
    const users = (blackbox && blackbox.raw && 'users' in blackbox.raw && blackbox.raw.users) || [];
    const user = users.find(i => i.public_id === req.query.publicId);

    const oauthUrl = new URL(config.oauthUrl);
    oauthUrl.pathname = 'authorize';
    const oauthOptionalQueryKeys: (keyof OauthQueryParams)[] = [
        'device_id',
        'device_name',
        'redirect_uri',
        'scope',
        'optional_scope',
        'force_confirm',
        'state',
        'display',
    ];
    const oauthQueryParams = oauthOptionalQueryKeys.reduce<OauthQueryParams>(
        (acc, key: keyof OauthQueryParams) => {
            if (req.query[key]) {
                acc[key] = String(req.query[key]);
            }
            return acc;
        },
        {
            client_id: String(req.query.client_id),
            response_type: String(req.query.response_type),
        },
    );
    oauthUrl.search = new URLSearchParams(oauthQueryParams).toString();

    if (req.cookies.yandexuid && req.query.publicId && user?.uid?.value && blackbox?.uid !== user?.uid?.value) {
        const passportUrl = new URL(config.passport.baseUrl);
        passportUrl.pathname = 'passport';
        passportUrl.search = new URLSearchParams({
            mode: 'embeddedauth',
            action: 'change_default',
            uid: user.uid.value,
            yu: req.cookies.yandexuid,
            retpath: oauthUrl.toString(),
        }).toString();
        return res.redirect(passportUrl.toString());
    }
    res.redirect(oauthUrl.toString());
};

export default handler;
