import * as fs from 'fs';

import type { RequestHandler } from 'express';
import type { ITicket } from '@yandex-int/express-tvm';

const handler: RequestHandler = (req, res, next) => {
    fs.readFile('/var/cache/yandex/passport-tvm-keyring/yandex_autofill_frontend.tickets', 'utf8', (err, contents) => {
        if (err) {
            req.log.error({
                err,
                type: 'service-tickets',
                code: 'service-tickets.read',
            });
            return next(err);
        }

        try {
            const tickets = Object.entries(
                (JSON.parse(contents).tickets || {}) as Record<string, { alias?: string; ticket: string }>,
            ).reduce<Record<string, ITicket>>((acc, [key, value]) => {
                const id = Number(key);

                if (typeof value.alias === 'string' && !isNaN(id)) {
                    acc[value.alias] = {
                        tvm_id: id,
                        ticket: value.ticket,
                    } as const;
                }
                return acc;
            }, {});

            req.tvm = {
                frontend: {
                    tickets,
                },
            };

            return next();
        } catch (_) {
            /* EMPTY */
        }

        const error = new Error('Service tickets could not be obtained');

        req.log.error({
            err: error,
            type: 'service-tickets',
            code: 'service-tickets.parse',
        });
        return next(error);
    });
};

export default handler;
