declare namespace ExpressBlackbox {
    interface Result {
        firstName: string;
        lastName: string;
        phones: {
            id: string;
            number: string;
            formatted: string;
            confirmed: string;
        }[];
        public_id: string;
    }
    interface PassportUser {
        id: string;
        public_id: string;
    }

    interface DisplayName {
        social?: {
            provider: import('../types').SocialProvider;
        };
    }
}

declare namespace Express {
    interface Request {
        id: string;
        ip: string;
        ssrId: string;
        nonce: string;
        services: import('./services').Services;
        log: import('@yandex-int/yandex-logger').Logger;
        makeRequest: import('./lib/requestFactory').RequestSender;
        langdetect: {
            id: string;
            name: string;
        };
    }
}
