import BaseService from './base';
import config from '../config';

import type { Request } from 'express';
import type { Options } from '../lib/requestFactory';

const { retry, https, timeout } = config.cloud;

export default class CloudService extends BaseService {
    requestOptions: Options | null = null;
    jsonRequestOptions: Options | null = null;

    constructor(req: Request) {
        super(req);

        if (this.req.tvm?.frontend.tickets?.cloud?.ticket && this.req.blackbox?.userTicket) {
            this.requestOptions = {
                retry,
                https,
                timeout,
                getErrorLogData: err => {
                    const headers = err.response?.headers;

                    return headers
                        ? {
                              headers: {
                                  'x-yandex-cloud-request-id':
                                      headers['yandex-cloud-request-id'] || headers['yandex-cloud-request-id'],
                              },
                          }
                        : {};
                },
                headers: {
                    'X-Ya-User-Ticket': this.req.blackbox.userTicket,
                    'X-Ya-Service-Ticket': this.req.tvm.frontend.tickets.cloud.ticket,
                    'Content-type': 'application/json',
                },
            };
        }
        if (this.requestOptions) {
            this.jsonRequestOptions = {
                ...this.requestOptions,
                responseType: 'json',
            };
        }
    }
}
