import BaseService from './base';
import config from '../config';

import type { Request } from 'express';

const { retry, timeout, host, baseUrl } = config.documentsAPI;

type Options = {
    timeout: number;
    retry: typeof retry;
    headers: Record<string, string>;
};

export default class DocumentsService extends BaseService {
    requestOptions: Options | null = null;
    jsonRequestOptions: (Options & { responseType: 'json' }) | null = null;

    constructor(req: Request) {
        super(req);

        if (this.req?.blackbox?.userTicket && this.req.tvm?.frontend.tickets?.documents?.ticket) {
            this.requestOptions = {
                retry,
                timeout,
                headers: {
                    Host: host,
                    'ya-consumer-client-ip': this.req.get('x-real-ip') || '',
                    'X-Ya-User-Ticket': this.req.blackbox.userTicket,
                    'X-Ya-Service-Ticket': this.req.tvm.frontend.tickets.documents.ticket,
                    'Content-type': 'application/json',
                },
            };
            this.jsonRequestOptions = {
                ...this.requestOptions,
                responseType: 'json',
            };
        }
    }

    getList = async ({ userId }: { userId: number }) => {
        return this.req.makeRequest<ANY>(`${baseUrl}/document/services`, {
            ...this.jsonRequestOptions,
            method: 'GET',
            searchParams: { user_id: userId },
        });
    };
}
