import YandexHttpGeo from '@yandex-int/node-http-geobase';
import { GeoServiceInstance } from './types';

export class HttpGeoService implements GeoServiceInstance {
    private lookup: YandexHttpGeo;

    constructor() {
        this.lookup = new YandexHttpGeo('http://geobase.qloud.yandex.ru');
    }

    async checkInternalNetwork(ip: string) {
        return (await this.lookup.traitsByIp(ip))?.is_yandex_net ?? false;
    }

    async getRegionId(ip: string) {
        return (await this.lookup.regionByIp(ip))?.id ?? null;
    }
}
