import config from '../../config';
import BaseService from '../base';
import { HttpGeoService } from './http';
import { LibraryGeoService } from './library';

import type { Request } from 'express';
import type { GeoServiceInstance } from './types';

export default class GeoService extends BaseService {
    private isInternalNetworkPromise: Promise<boolean> = Promise.resolve(false);
    private regionIdPromise: Promise<number | null> = Promise.resolve(null);

    constructor(req: Request) {
        super(req);

        const ip = this.req.get('x-real-ip') || null;

        if (!ip) {
            return;
        }

        const geoInstance: GeoServiceInstance = config.local ? new HttpGeoService() : new LibraryGeoService();

        this.isInternalNetworkPromise = geoInstance.checkInternalNetwork(ip).catch(err => {
            this.req.log.error({ err, type: 'geo-service', code: 'isInternalNetwork' });
            return false;
        });

        this.regionIdPromise = geoInstance.getRegionId(ip).catch(err => {
            this.req.log.error({ err, type: 'geo-service', code: 'regionId' });
            return null;
        });
    }

    async checkInternalNetwork() {
        return this.isInternalNetworkPromise;
    }

    async getRegionId() {
        return this.regionIdPromise;
    }
}
