import yandexGeo, { geobase6 } from '@yandex-int/yandex-geobase';
import { GeoServiceInstance } from './types';

export class LibraryGeoService implements GeoServiceInstance {
    private lookup: geobase6.GeobaseLookup;

    constructor() {
        this.lookup = yandexGeo.v6({
            geobaseData: '/var/cache/geobase/geodata6.bin',
        });
    }

    async checkInternalNetwork(ip: string) {
        return this.lookup.getIpTraits(ip)?.yandex_net ?? false;
    }

    async getRegionId(ip: string) {
        return (await this.lookup.getRegionIdByIp(ip)) ?? null;
    }
}
