import GeoService from './geo';
import MiscService from './misc';
import UserService from './user';
import CloudService from './cloud';
import PassportService from './passport';
import SocialService from './social';
import DocumentsService from './documents';

import type { Request } from 'express';

export type Services = {
    geo: GeoService;
    user: UserService;
    misc: MiscService;
    cloud: CloudService;
    passport: PassportService;
    social: SocialService;
    documents: DocumentsService;
};

export default (req: Request): Services => ({
    geo: new GeoService(req),
    user: new UserService(req),
    misc: new MiscService(req),
    cloud: new CloudService(req),
    passport: new PassportService(req),
    social: new SocialService(req),
    documents: new DocumentsService(req),
});
