export type FieldError =
    | 'toolong'
    | 'required'
    | 'internal'
    | 'phone.invalid'
    | 'email.invalid'
    | 'firstName.invalid'
    | 'lastName.invalid'
    | 'address.invalid'
    | 'address.required.city'
    | 'address.required.street'
    | 'address.required.country'
    | 'address.required.building';

export type Field = 'firstName' | 'lastName' | 'phone' | 'email' | 'address';

export type Theme = 'light' | 'dark';

export type Meta = {
    whitelist: Field[];
    targetOrigin: string;
    controlSum: string;
};

export type BundleDSItem = {
    id: string;
    name: string;
    value: string;
};

export type BundleDSResponseItem = {
    id: string;
    phones: BundleDSItem[];
    emails: BundleDSItem[];
    lastnames: BundleDSItem[];
    firstnames: BundleDSItem[];
};

export type MarketDSItem = {
    id: string;
    city: string;
    title: string;
    street: string;
    country: string;
    building: string;
    addressLine: string;
};

export type MarketDSResponse = {
    items: MarketDSItem[];
};

export type APIBody = {
    acceptDocumentsAgreement: {
        req: Record<string, string>;
        res: { status: 'error' | 'ok'; errors?: string[] }
    };
    save: {
        req: { id: string } & Partial<Record<Field, string>>;
        res: { status: 'ok'; errors?: never } | { status: 'error'; errors?: Record<Field, FieldError | null> };
    };
};

export type BaseMakeRequestResult = {
    status: string;
    errors?: string[];
}

export type AutofillProfile = {
    firstName: string;
    middleName: string;
    lastName: string;
    fullName: string;
    email: string;
    phoneNumber: string;
    streetAddress: string;
};

export type AutofillProfilePresets = {
    profiles: AutofillProfile[];
    models: {
        email: string[];
        phone: string[];
        address: string[];
    };
};

export type UserModels = {
    emails: string[];
    phones: string[];
    addresses: string[];
};

export type UserProfile = {
    firstName?: string;
    middleName?: string;
    lastName?: string;
    fullName?: string;
    phone?: string;
    email?: string;
    address?: string;
};

export type User = {
    yu: string;
    uid: string;
    firstName: string;
    lastName: string;
    emails: string[];
    phones: string[];
    addresses: string[];
    avatar: {
        id?: string | null;
        middle: string;
        retinaMiddle: string;
    };
};
export type SocialProvider = 'vk' | 'fb' | 'gg' | 'mr' | 'ok' | 'tw';
export type SuggestUser = {
    publicId: string;
    avatar: string;
    name: string;
    firstName?: string;
    defaultEmail?: string;
    socialProvider?: SocialProvider;
    hasPlus?: boolean;
};
export type InitialErrors = {
    user?: string | null;
    users?: string | null;
};
export type Locs = {
    errors: Record<FieldError, string>;
    suggest: Record<string, string>;
    social: Record<string, string>;
    common: Record<string, string>;
    extended: Record<string, string>;
};

export type SuggestButtonOptions = {
    buttonSize?: string;
    buttonView?: string;
    buttonTheme?: string;
    buttonBorderRadius?: string;
}

export type Constants = {
    tld: string;
    ssrId: string;
    dev?: boolean;
    lang: 'ru' | 'en';
    metrikaId?: string;
    type: 'embedded' | 'popup' | 'bro' | 'suggest' | 'provider';
    isDrawer?: boolean;
    passportAuthUrl: string;
    passportAuthUpdateUrl: string;
    avatarTemplate: string;
    experiments?: {
        flags?: string[];
        boxes?: string[];
    };
    encodedBoxes?: string;
    theme: Theme;
    suggestView?: string;
    suggestButtonOptions?: SuggestButtonOptions;
};
export type RenderProps = {
    csrfToken: string;
    meta: Meta;
    user: User | null;
    users: SuggestUser[];
    profiles: UserProfile[];
    nonce: string;
    assetsPath: string;
    constants: Constants;
    initialErrors: InitialErrors;
    locals: Locs;
};

export type ProviderData = {
    user: SuggestUser;
    processName: 'save' | 'autofill';
    docs: {
        services: {
            'doc_type': DocumentType;
            'service_name': ServiceName;
        }[];
    };
};

export type ServiceName = string;
export type DocumentType = 'national_id' | 'international_id' | 'driver_license' | 'inn' | 'snils';
