#!/usr/bin/env bash

VERSION=$(cat ./debian/changelog | head -1 | sed 's/^.*(//' | sed 's/).*$//')

npm version "$VERSION" --no-git-tag-version
arc add package.json package-lock.json debian

arc commit -m "NOTASK: Build $VERSION" --no-verify

echo "TAG $VERSION"
arc tag "$VERSION"

arc push 
arc push "$VERSION"

exit 0
