#!/usr/bin/env bash

DIMENSIONS=('1024x576' '1280x720' '1440x810' '1680x945' '1920x1080')

bg_numbers=($(ls $PWD/i/))
output_styl_file="$PWD/src/bg.sass"

bg_styl="
.passp-bg
  position: fixed
  z-index: -1
  top: 0
  bottom: 0
  left: 0
  right: 0
  background-repeat: no-repeat
  background-position: 50%
  background-size: cover

  &_4080
    background-position: 0 0

    &::before
      background: none !important
"

index=0

for dimension in "${DIMENSIONS[@]}"; do
    width=`echo $dimension | sed 's/x.*$//'`
    height=`echo $dimension | sed 's/^.*x//'`

    if [[ $index == 0 ]]; then
        bg_styl+="
  @media only screen and (min-width: 0), only screen and (min-height: 0)
    "
    else
        bg_styl+="
  @media only screen and (min-width: $(echo $width)px), only screen and (min-height: $(echo $height)px)
    "
    fi

    for bg in "${bg_numbers[@]}"; do
        file=($(ls $PWD/i/$bg))
        extension="${file##*.}"

        responsive_url="../i/$bg/bg_$(echo $width)w.$(echo $extension)"

        bg_styl+="
        &_$bg
            background-image: url('$responsive_url')
        "
    done

    index=$(expr $index + 1)
done

bg_styl+="
.passp-bg:before
    content: ''
    position: absolute
    top: 0
    right: 0
    bottom: 0
    left: 0
    background: rgba(0,0,0,.2)
"

rm -f $output_styl_file
touch $output_styl_file
echo "$bg_styl" > $output_styl_file

