const fs = require('fs');
const path = require('path');

module.exports = () => {
    const _locs = require('./_customs.json'); // eslint-disable-line global-require

    fs.writeFileSync(
        path.join(__dirname, 'customs.json'),
        JSON.stringify(
            Object.keys(_locs).reduce((nlocs, lang) => {
                nlocs[lang] = Object.keys(_locs[lang]).reduce((nset, key) => {
                    nset = Object.assign(
                        {},
                        nset,
                        Object.keys(_locs[lang][key]).reduce((acc, ikey) => {
                            acc[`${key}.${ikey}`] = _locs[lang][key][ikey];
                            return acc;
                        }, {})
                    );
                    return nset;
                }, {});
                return nlocs;
            }, {}),
            null,
            '\t'
        ),
        'utf-8'
    );
};
