#!/usr/bin/env bash

VERSION=$(cat ./debian/changelog | head -1 | sed 's/^.*(//' | sed 's/).*$//')

echo "RELEASE $VERSION"

echo "LOC UP"
make loc
git add locs
git commit -m "NOTASK: loc up" --no-verify

echo "BUILD"
make
git add dist src
git commit -m "NOTASK: build dist" --no-verify

npm version "$VERSION"
git add package.json package-lock.json

git add debian
git commit -m "NOTASK: Build $VERSION" --no-verify

echo "VERSION UP $VERSION"
rm -rf ./customs.version.json
touch ./customs.version.json
echo "{\"version\": \"$VERSION\"}" > ./customs.version.json

git add ./customs.version.json
git commit -m "NOTASK: version up" --no-verify

echo "TAG $VERSION"
git tag "customs-$VERSION"

git push -u origin HEAD
git push origin "customs-$VERSION"

exit 0
