const sharp = require('sharp');
const fs = require('fs');
const path = require('path');

const createDir = async (dirname) => new Promise((resolve) => fs.mkdir(dirname, resolve));

const [filename = './tools/resize.jpg', number = 0, ext = 'jpg'] = process.argv.slice(2);

const filepath = path.join(__dirname, '..', filename);

const img = sharp(fs.readFileSync(filepath));

const outputDir = path.join(__dirname, '..', `./i/${number}`);

(async () => {
    await createDir(outputDir);
    return await Promise.all(
        [1024, 1280, 1440, 1680, 1920].map(async (width) => {
            const output = `${outputDir}/bg_${width}w.${ext}`;

            await img.clone().resize({width}).toFile(output);
            console.log(`Image ${filename} resized to ${width}px width and saved in ${output}`);
        })
    );
})();
