const TerserJSPlugin = require('terser-webpack-plugin');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const OptimizeCSSAssetsPlugin = require('optimize-css-assets-webpack-plugin');
const path = require('path');
const { staticPath, freezePath } = require('@yandex-int/static-uploader')

module.exports = {
    module: {
        rules: [
            // {
            //     test: /\.(jpg|jpeg|png|svg)$/,
            //     exclude: [path.resolve(__dirname, './node_modules')],
            //     use: {
            //         loader: 'file-loader',
            //         options: {
            //             name: '[path][hash].[ext]'
            //         }
            //     }
            // },
            {
                test: /\.(jpg|jpeg|png|svg)$/,
                exclude: [path.resolve(__dirname, './node_modules')],
                use: {
                    loader: 'file-loader',
                    options: {
                        name: '[sha1:hash:base58:8].[ext]',
                        outputPath: url => { return `_/${url}` },
                        publicPath: freezePath // Зафриженная статика
                    }
                }
            },
            {
                test: /\.(css|sass)$/,

                use: [
                    {
                        loader: MiniCssExtractPlugin.loader
                    },
                    {
                        loader: 'css-loader'
                    },
                    {
                        loader: 'sass-loader'
                    }
                ]
            }
        ]
    },

    mode: 'production',

    output: {
        path: path.resolve(__dirname, 'dist'),
        publicPath: staticPath // Версионируемая статика
    },

    plugins: [
        new MiniCssExtractPlugin({
            filename: 'passport.auth.customs.css'
        })
    ],

    resolve: {
        extensions: ['.js', '.sass']
    },

    optimization: {
        minimizer: [new TerserJSPlugin({}), new OptimizeCSSAssetsPlugin({})]
    }
};
