const config = require('./configs/current');
const bodyParser = require('body-parser');
const cookieParser = require('cookie-parser');
const serveStatic = require('serve-static');
const express = require('express');
const app = express();
const helmet = require('helmet');
const getYaExperimentsFlags = require('./lib/getYaExperimentsFlags');
const externals = require('./yateBlocks/_externals/externals.js');
const yateRuntime = require('yate/lib/runtime.js');

app.set('views', `${__dirname}/views`);
app.use(cookieParser());
app.use(
    bodyParser.urlencoded({
        extended: false
    })
);
app.use(helmet.noCache());

// X-Forwarded-For нет, 'trust proxy' бесполезно
app.disable('trust proxy');
app.disable('x-powered-by');

app.use((req, res, next) => {
    Object.defineProperty(req, 'ip', {
        value: req.get('x-real-ip')
    });

    return next();
});

app.use(getYaExperimentsFlags);
app.use((req, res, next) => {
    const {experiments = {}} = res.locals;
    const {flags = []} = experiments;

    app.use(serveStatic(`${__dirname}/data`));

    if ('development' === app.get('env')) {
        app.use('/st', express.static(`${__dirname}/${flags.includes('socializm-new-exp') ? 'dist' : 'data'}`));
    }

    return next();
});

if (['development', 'testing'].indexOf(app.get('env')) !== -1) {
    require('./routes/index').route(app);
}

require('./routes/authz_in_web/start').route(app);
require('./routes/authz_in_web/callback').route(app);
require('./routes/authz_in_web/bindGet').route(app);
require('./routes/authz_in_web/bindPost').route(app);
require('./routes/authz_in_web/collectDiagnostics.js').route(app);
require('./routes/control').route(app);

// old routes

externals(yateRuntime);

if (['development', 'testing'].indexOf(app.get('env')) !== -1) {
    require('./oldRoutes/index').route(app);
}

require('./oldRoutes/authz_in_web/start').route(app);
require('./oldRoutes/authz_in_web/callback').route(app);
require('./oldRoutes/authz_in_web/bindGet').route(app);
require('./oldRoutes/authz_in_web/bindPost').route(app);
require('./oldRoutes/authz_in_web/collectDiagnostics.js').route(app);
require('./oldRoutes/control').route(app);

// old routes

app.get(`${config.path}/ping`, (req, res) => {
    res.status(200).send('pong');
});

app.listen(process.env.PORT || process.env.npm_package_config_port || config.port);

module.exports = app;
