import './App.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Logo} from '@components/Logo';
import {Captcha} from '@components/Captcha';
import {Demo} from '@blocks/Demo';
import {Redirector} from '@blocks/Redirector';
import {Error} from '@blocks/Error';
import {Bind} from '@blocks/Bind';
import {FormBind} from '@blocks/FormBind';
import {resizeWindow} from '@lib/utils';

const b = cn('App');

class App extends React.PureComponent {
    componentDidMount() {
        const {window, screen} = this.props;

        if (screen !== 'redirector') {
            resizeWindow(window);
        }
    }

    getScreen = () => {
        const {screen} = this.props;

        switch (screen) {
            case 'redirector': {
                return <Redirector />;
            }

            case 'demo': {
                return <Demo />;
            }

            case 'error': {
                return <Error />;
            }

            case 'bind': {
                return <Bind />;
            }

            case 'formBind': {
                return <FormBind />;
            }

            case 'captcha': {
                return <Captcha />;
            }

            default: {
                return null;
            }
        }
    };

    render() {
        return (
            <div className={b()}>
                <div className={b('header')}>
                    <Logo isStatic={true} />
                </div>
                <div className={b('body')}>{this.getScreen()}</div>
            </div>
        );
    }
}

App.propTypes = {
    screen: PropTypes.oneOf(['redirector', 'demo', 'error', 'bind', 'formBind', 'captcha']).isRequired,
    location: PropTypes.string,
    window: PropTypes.shape({
        width: PropTypes.number,
        height: PropTypes.height
    })
};

export {App};
