import './Bind.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Description} from '@components/Description';
import {Button} from '@components/Button';

const b = cn('Bind');

class Bind extends React.PureComponent {
    render() {
        const {description, buttons = {}, bindUrl, cancelUrl, isMobile} = this.props;
        const {proceed, close} = buttons;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Description>
                        <span dangerouslySetInnerHTML={{__html: description}} />
                    </Description>
                </div>
                <div className={b('body')} />
                <div className={b('controls')}>
                    <Button type='link' url={bindUrl} text={proceed} width={isMobile ? 'max' : 'auto'} />
                    <Button type='link' url={cancelUrl} text={close} theme='normal' width={isMobile ? 'max' : 'auto'} />
                </div>
            </div>
        );
    }
}

Bind.propTypes = {
    description: PropTypes.string.isRequired,
    buttons: PropTypes.shape({
        close: PropTypes.string.isRequired,
        proceed: PropTypes.string.isRequired
    }).isRequired,
    bindUrl: PropTypes.string,
    cancelUrl: PropTypes.string,
    isMobile: PropTypes.bool
};

export {Bind};
