import './Button.styl';
import React from 'react';
import PropTypes from 'prop-types';
import LegoButton from 'lego-on-react/src/components/button/button.react';
import {cn} from '@bem-react/classname';

const b = cn('Button');

class Button extends React.PureComponent {
    static defaultProps = {
        type: 'submit',
        theme: 'action',
        size: 'l'
    };

    render() {
        const {type, text, theme, tone, view, url, onClick, disabled, size, width} = this.props;

        return (
            <div className={b('', {size})}>
                <LegoButton
                    type={type}
                    theme={theme}
                    tone={tone}
                    view={view}
                    url={url}
                    onClick={onClick}
                    disabled={disabled}
                    size={size}
                    width={width}
                >
                    {text}
                </LegoButton>
            </div>
        );
    }
}

Button.propTypes = {
    type: PropTypes.string,
    text: PropTypes.oneOfType([PropTypes.string, PropTypes.object]),
    theme: PropTypes.string,
    tone: PropTypes.string,
    view: PropTypes.string,
    url: PropTypes.string,
    onClick: PropTypes.func,
    disabled: PropTypes.bool,
    size: PropTypes.oneOf(['m', 'l']),
    width: PropTypes.string
};

export {Button};
