import './Captcha.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import {Field} from '@components/Field';

const b = cn('Captcha');

class Captcha extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            error: ''
        };
    }

    ref = React.createRef();
    close = () => window.close();
    onFieldChange = () => this.setState({error: ''});

    proceed = (event) => {
        const {captcha = {}} = this.props;
        const {missingvalue} = captcha;
        const {value} = (this.ref.current && this.ref.current.state) || {};

        if (!value) {
            event.preventDefault();
            this.setState({
                error: missingvalue
            });
        }
    };

    render() {
        const {description, captchaUrl, captchaSid, checkFailed, captcha = {}, buttons = {}} = this.props;
        const {label, incorrect} = captcha;
        const {close, proceed} = buttons;
        const {error} = this.state;

        return (
            <form method='post' className={b()}>
                <div className={b('head')}>
                    <Description>
                        <span dangerouslySetInnerHTML={{__html: description}} />
                    </Description>
                </div>

                <div className={b('body')}>
                    <div className={b('image-container')}>
                        <img src={captchaUrl} className={b('image')} alt='captcha image' />
                    </div>

                    <Field
                        ref={this.ref}
                        name='captcha_answer'
                        label={label}
                        error={checkFailed ? incorrect : error}
                        options={{autoComplete: 'off'}}
                        onFieldChange={this.onFieldChange}
                    />

                    <input type='hidden' name='captcha_sid' value={captchaSid} />
                </div>

                <div className={b('controls')}>
                    <Button text={proceed} width='max' onClick={this.proceed} />
                    <Button text={close} width='max' theme='normal' type='button' onClick={this.close} />
                </div>
            </form>
        );
    }
}

Captcha.propTypes = {
    description: PropTypes.string.isRequired,
    captchaUrl: PropTypes.string.isRequired,
    captchaSid: PropTypes.string.isRequired,
    checkFailed: PropTypes.bool,
    captcha: PropTypes.shape({
        incorrect: PropTypes.string.isRequired,
        missingvalue: PropTypes.string.isRequired,
        label: PropTypes.string.isRequired
    }),
    buttons: PropTypes.shape({
        close: PropTypes.string.isRequired,
        proceed: PropTypes.string.isRequired
    }).isRequired
};

export {Captcha};
