import './Logo.styl';
import React from 'react';
import PropTypes from 'prop-types';
import Logo from 'lego-on-react/src/components/logo/logo.react';

class YandexLogo extends React.PureComponent {
    constructor(props) {
        super(props);

        this.isRuLogo = !props.language || ['ru', 'uk'].indexOf(props.language) !== -1;
        this.logoName = `ys-${this.isRuLogo ? 'ru' : 'en'}-${this.isRuLogo ? '98' : '102'}x42`;
    }

    render() {
        const {tld, isStatic} = this.props;
        const props = isStatic
            ? {}
            : {
                  type: 'link',
                  tabIndex: '-1',
                  url: `//yandex.${tld}`
              };

        return <Logo name={this.logoName} {...props} {...this.props} />;
    }
}

YandexLogo.propTypes = {
    language: PropTypes.string.isRequired,
    tld: PropTypes.string.isRequired,
    isStatic: PropTypes.bool
};

export {YandexLogo as Logo};
