import './Demo.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Link} from '@components/Link';
import {openWindow} from '@lib/utils';

const b = cn('Demo');

class Demo extends React.PureComponent {
    onItemClick = ({event, app, url}) => {
        const {displayType} = this.props;

        if (displayType === 'popup') {
            event.preventDefault();
            openWindow(url, app);
        }
    };

    renderProvider = (provider = {}) => {
        const {displayType} = this.props;
        const {name, app} = provider;
        const url = `/broker2/demo_entry?provider=${encodeURIComponent(app)}&display=${encodeURIComponent(
            displayType
        )}&consumer=passport&retpath=https://social-test.yandex.ru/broker2`;

        return (
            <li key={`provider-${app}`} className={b('item')}>
                <Link url={url} onClick={(event) => this.onItemClick({event, app, url})}>
                    {name}
                </Link>
            </li>
        );
    };

    render() {
        const {providers} = this.props;

        return <ul className={b()}>{providers.map((provider) => this.renderProvider(provider))}</ul>;
    }
}

Demo.propTypes = {
    displayType: PropTypes.oneOf(['touch', 'popup']),
    providers: PropTypes.arrayOf(
        PropTypes.shape({
            name: PropTypes.string.isRequired,
            app: PropTypes.oneOf(['fb', 'tw', 'vk', 'gg', 'mr', 'ok', 'ig', 'lf', 'lj', 'sberbank']).isRequired
        })
    )
};

export {Demo};
