import {connect} from 'react-redux';
import {Demo} from './Demo';

const mapStateToProps = (state = {}) => {
    const {settings = {}, app = {}} = state;
    const {uatraits = {}} = settings;
    const {isMobile} = uatraits;
    const {providers = []} = app;

    return {
        providers,
        displayType: isMobile ? 'touch' : 'popup'
    };
};

const ConnectedDemo = connect(mapStateToProps)(Demo);

export {ConnectedDemo as Demo};
