import './Error.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {Button} from '@components/Button';
import {resizeWindowByProvider} from '@lib/utils';

const b = cn('Error');

class Error extends React.PureComponent {
    onRetryClick = () => {
        const {provider} = this.props;

        if (provider) {
            resizeWindowByProvider(provider);
        }
    };

    onCloseClick = (event) => {
        const {retpath} = this.props;

        if (!retpath) {
            window.close();
            event.preventDefault();
        }
    };

    maybeRenderCloseButton = () => {
        const {retpath, buttons = {}, noForceClose, isMobile} = this.props;
        const {close} = buttons;

        if (!retpath && noForceClose) {
            return null;
        }

        return (
            <Button
                text={close}
                theme='normal'
                width={isMobile ? 'max' : 'auto'}
                url={retpath}
                type='link'
                onClick={this.onCloseClick}
            />
        );
    };

    render() {
        const {title, description, retryUrl, requestId, buttons = {}, process, isMobile} = this.props;
        const {retry, back} = buttons;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title>{title}</Title>
                    <Description>
                        <span dangerouslySetInnerHTML={{__html: description}} />
                    </Description>
                </div>

                <div className={b('body')}>{requestId && <div className={b('request-id')}>{requestId}</div>}</div>

                <div className={b('controls')}>
                    {retryUrl && (
                        <Button
                            text={process === 'authzInWeb' ? back : retry}
                            width={isMobile ? 'max' : 'auto'}
                            url={retryUrl}
                            type='link'
                            onClick={this.onRetryClick}
                        />
                    )}
                    {this.maybeRenderCloseButton()}
                </div>
            </div>
        );
    }
}

Error.propTypes = {
    provider: PropTypes.string,
    title: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    retryUrl: PropTypes.string,
    buttons: PropTypes.shape({
        close: PropTypes.string.isRequired,
        retry: PropTypes.string.isRequired,
        back: PropTypes.string.isRequired
    }).isRequired,
    requestId: PropTypes.string,
    retpath: PropTypes.string,
    noForceClose: PropTypes.bool,
    isMobile: PropTypes.bool,
    process: PropTypes.string
};

export {Error};
