import {connect} from 'react-redux';
import {Error} from './Error';

const mapStateToProps = (state = {}) => {
    const {app = {}, buttons = {}, settings = {}} = state;
    const {
        title,
        description,
        retpath,
        request_id: requestId,
        retry_url: retryUrl,
        provider,
        process,
        noForceClose
    } = app;
    const {uatraits = {}} = settings;
    const {isMobile} = uatraits;

    return {
        title,
        description,
        retpath,
        requestId,
        retryUrl,
        provider,
        buttons,
        noForceClose,
        process,
        isMobile
    };
};
const ConnectedError = connect(mapStateToProps)(Error);

export {ConnectedError as Error};
