import './FormBind.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Title} from '@components/Title';
import {Description} from '@components/Description';
import {Button} from '@components/Button';

const b = cn('FormBind');

class FormBind extends React.PureComponent {
    onCloseClick = (event) => {
        const {cancelUrl} = this.props;

        if (!cancelUrl) {
            window.close();
            event.preventDefault();
        }
    };

    render() {
        const {title, description, cancelUrl, buttons = {}, csrfToken, isMobile} = this.props;
        const {proceed, close} = buttons;

        return (
            <div className={b()}>
                <div className={b('head')}>
                    <Title>{title}</Title>
                    <Description>
                        <span dangerouslySetInnerHTML={{__html: description}} />
                    </Description>
                </div>

                <div className={b('body')} />

                <div className={b('controls')}>
                    <form method='post'>
                        <input type='hidden' name='_csrf' value={csrfToken} />
                        <Button text={proceed} width='max' />
                        <Button
                            text={close}
                            width={isMobile ? 'max' : 'auto'}
                            url={cancelUrl}
                            type='link'
                            onClick={this.onCloseClick}
                            theme='normal'
                        />
                    </form>
                </div>
            </div>
        );
    }
}

FormBind.propTypes = {
    title: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    cancelUrl: PropTypes.string,
    buttons: PropTypes.shape({
        close: PropTypes.string.isRequired,
        proceed: PropTypes.string.isRequired
    }).isRequired,
    csrfToken: PropTypes.string.isRequired,
    isMobile: PropTypes.bool
};

export {FormBind};
