import React from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import {resizeWindowByProvider, redirect} from '@lib/utils';

class Redirector extends React.PureComponent {
    componentDidMount() {
        const {location, provider} = this.props;

        if (provider) {
            resizeWindowByProvider(provider);
        }

        if (location) {
            return redirect(location);
        }
    }

    render() {
        return <Spin progress={true} view='default' size='l' position='center' />;
    }
}

Redirector.propTypes = {
    location: PropTypes.string.isRequired,
    provider: PropTypes.oneOf(['fb', 'tw', 'vk', 'gg', 'mr', 'ok', 'ig', 'lf', 'lj', 'sberbank'])
};

export {Redirector};
