#!/bin/bash

echo "Copying changelog from `pwd`/debian/changelog to ../debian"
VERSION=`dpkg-parsechangelog | sed -n 's/^Version: //p'`
cat ./debian/changelog | sed "s/yandex-broker2-www/yandex-broker2-www-static-$VERSION/" > ./build/client/debian/changelog


echo "Copying dh definitions for version $VERSION"
cp build/client/debian/yandex-broker2-www-static.dirs.template debian/yandex-broker2-www-static-${VERSION}.dirs
sed -i "s/{{VERSION}}/$VERSION/g" debian/yandex-broker2-www-static-${VERSION}.dirs

cp build/client/debian/yandex-broker2-www-static.install.template debian/yandex-broker2-www-static-${VERSION}.install
sed -i "s/{{VERSION}}/$VERSION/g" debian/yandex-broker2-www-static-${VERSION}.install

cp build/client/debian/postinst debian/postinst
sed -i "s/{{VERSION}}/$VERSION/g" debian/postinst
chmod a+x debian/postinst

cp build/client/debian/control debian/control
cp build/client/debian/rules debian/rules
cp build/client/debian/compat debian/compat
cp build/client/debian/changelog debian/changelog
echo "Writing version into debian/control"
sed -i "s/yandex-passport-frontend-static-/yandex-passport-frontend-static-$VERSION/g" debian/control

cat debian/control


echo "Writing version into debian/control"
sed -i "s/yandex-broker2-www-static-/yandex-broker2-www-static-$VERSION/g" debian/control

_PWD=`pwd`
_DIR=`basename ${_PWD}`
_PWD=`dirname ${_PWD}`
echo "Building"
# build-package-pbuilder ${_DIR} --upload-to verstka --with-cowbuilder --ov-source-path ${_PWD} || exit 3
build-package-pbuilder ${_DIR} --upload-to verstka --basetgz base-nodejs.tgz --ov-source-path ${_PWD} || exit 3



# if [ "x$MANUAL_BUILD" == "x0" ]; then
    echo `conductor-ticket --branch=stable --comment='Uploading static for build http://quigon.yandex.ru/viewLog.html?buildId='${BUILD_ID} --auth buildfarm yandex-broker2-www-static=${VERSION}`
# fi;
