#!/bin/bash

cp build/server/debian/* debian/

VERSION=`dpkg-parsechangelog | sed -n 's/^Version: //p'`
sed -i "s/{{VERSION}}/$VERSION/g" configs/production/index.js
sed -i "s/{{VERSION}}/$VERSION/g" configs/rc/index.js
sed -i "s/{{VERSION}}/$VERSION/g" configs/testing/index.js

# make node_modules NPMCACHE=n
# popd

_PWD=`pwd`
_DIR=`basename ${_PWD}`
_PWD=`dirname ${_PWD}`
echo "Building for ${TYPE}"

REPO=passport-trusty

# build-package-pbuilder ${_DIR} --upload-to ${REPO} --with-cowbuilder --ov-source-path ${_PWD} || exit 3
build-package-pbuilder ${_DIR} --upload-to ${REPO} --basetgz base-nodejs.tgz --ov-source-path ${_PWD} || exit 3
