import React from 'react';
import PropTypes from 'prop-types';

const Template = ({staticPath, store, title, isTouch, children}) => {
    return (
        <html className={isTouch ? 'is-touch' : ''}>
            <head>
                <title>{title}</title>
                <meta charSet='utf-8' />
                <link rel='shortcut icon' href='//yastatic.net/morda-logo/i/favicon_islands.ico' />
                <link rel='stylesheet' href={`${staticPath}/index.css`} />
            </head>
            <body data-store={JSON.stringify(store)}>
                <div id='app'>{children}</div>
                <script crossOrigin='anonymous' src={`${staticPath}/index.client.js`} />
            </body>
        </html>
    );
};

Template.propTypes = {
    isTouch: PropTypes.bool.isRequired,
    title: PropTypes.string.isRequired,
    staticPath: PropTypes.string.isRequired,
    store: PropTypes.object.isRequired,
    children: PropTypes.node.isRequired
};

export {Template};
