const got = require('got');
const config = require('../configs/current');

module.exports = {
    call: (url, params) => {
        const instance = got.extend({
            baseUrl: `${config.url.protocol}://${config.url.host}`,
            query: {
                consumer: 'broker-frontend'
            },
            form: true,
            json: true,
            headers: {
                'Ya-Consumerid': 'broker-frontend'
            },
            body: {
                frontend_url: config.frontend_url
            },
            hooks: {
                beforeRequest: [
                    (options) => {
                        return options;
                    }
                ],
                afterResponse: [
                    (response) => {
                        console.log(response.statusCode, response.body);
                        return response;
                    }
                ]
            }
        });

        return instance(url, params);
    }
};
