const config = require('../configs/current');
const langdetect = require('./langDetect');
const blackbox = require('express-blackbox');
const yandexuid = require('express-yandexuid');
const uatraits = require('express-uatraits');
const utils = require('./node-utils');
const locs = require('../loc/social.json');
const passportLocs = require('../loc/passport.json');

module.exports = [
    (req, res, next) => {
        if (req.cookies && req.cookies.Session_id) {
            return blackbox({
                api: config.blackbox
            })(req, res, next);
        }

        next();
    },
    (req, res, next) => {
        if (req.blackbox && req.blackbox.status === 'VALID') {
            req.blackbox.dbfields = {
                'userinfo.lang.uid': req.blackbox.lang
            };
        }

        if (req.blackbox && req.blackbox.error !== 'OK') {
            console.log(
                'ERROR blackbox error',
                '[' + new Date() + ']',
                req.headers['x-real-ip'],
                req.headers['user-agent'],
                JSON.stringify(req.blackbox)
            );
        }

        next();
    },
    langdetect({
        defaultLanguage: 'ru',
        availableLanguages: {
            az: ['ru', 'en'],
            'com.am': ['ru', 'en'],
            'com.ge': ['ru', 'en'],
            'co.il': ['en'],
            kg: ['ru', 'en'],
            lv: ['ru', 'en'],
            lt: ['ru', 'en'],
            md: ['ru', 'en'],
            tj: ['ru', 'en'],
            tm: ['ru', 'en'],
            uz: ['ru', 'en'],
            fr: ['en', 'ru', 'ua'],
            ee: ['ru', 'en'],
            ru: ['ru', 'uk', 'en'],
            ua: ['ru', 'uk', 'en'],
            by: ['ru', 'uk', 'en'],
            kz: ['ru', 'uk', 'en'],
            com: ['en', 'id', 'fr', 'fi'],
            'com.tr': ['tr', 'en'],
            default: ['ru', 'en', 'uk', 'tr']
        },
        geobaseVersion: 5,
        list: true
    }),
    uatraits({
        browser: '/usr/share/uatraits/browser.xml',
        profiles: '/usr/share/uatraits/profiles.xml',
        uatraits: '/usr/lib/node_modules/uatraits'
    }),
    yandexuid(),
    function createStore(req, res, next) {
        const {langdetect = {}, uatraits = {}} = req;
        const language = (['ru', 'en', 'uk', 'tr'].includes(langdetect.id) && langdetect.id) || 'ru';
        const loc = locs[language];
        const passportLoc = passportLocs[language]['Frontend'];

        res.locals.language = language;
        res.locals.store = {
            window: {
                width: 650,
                height: 400
            },
            captcha: {
                incorrect: passportLoc['answer_errors_incorrect'] || '',
                missingvalue: passportLoc['answer_errors_missingvalue'] || '',
                label: passportLoc['field_answer'] || ''
            },
            buttons: {
                close: loc.common['button.close'],
                retry: loc.error.retry.replace('&nbsp;', ' '),
                proceed: loc.common['button.continue'],
                back: loc.common['button.back']
            },
            settings: {
                staticPath: config.staticPath,
                language,
                uatraits,
                tld: utils.getTld(req.hostname),
                title: loc.common['title.passport']
            }
        };

        next();
    }
];
