import {createStore, combineReducers} from 'redux';

const stub = (state = {}) => state;

const mainReducer = combineReducers({
    settings: stub,
    app: stub,
    buttons: stub,
    captcha: stub,
    window: stub
});

const devTools =
    typeof window === 'object' &&
    typeof window.devToolsExtension !== 'undefined' &&
    process.env.NODE_ENV !== 'production'
        ? window.devToolsExtension()
        : (f) => f;

const configureStore = (state) => createStore(mainReducer, state, devTools);

export {configureStore};
