const querystring = require('querystring');
const request = require('request');

module.exports = {
    call: (url, params) => {
        const data = querystring.stringify(params);

        return new Promise((resolve) =>
            request(
                {
                    pool: {
                        maxSockets: 200
                    },
                    url,
                    method: 'POST',
                    body: data,
                    headers: {
                        'Content-type': 'application/x-www-form-urlencoded; charset=utf-8',
                        'Ya-Consumerid': 'broker-frontend',
                        'Content-Length': data.length
                    },
                    timeout: 20000
                },
                (err, response, data) => {
                    resolve({err, response, data});
                }
            )
        );
    }
};
