const config = require('../configs/current');
const util = require('util');
const url = require('url');
const request = require('request');

const getYaExperimentsInfoPromise = (req) => {
    const {cookies = {}, headers = {}, query = {}} = req;
    const userAgent = headers['user-agent'];
    const xForwardedFor = headers['x-real-ip'];
    const testId = cookies['test-id'] || query['test-id'];
    const flagId = cookies['flag-id'] || query['flag-id'];
    const requestHeaders = {
        Cookie: util.format('yandexuid=%s', cookies.yandexuid),
        'User-Agent': userAgent,
        'X-Forwarded-For-Y': xForwardedFor
    };

    let uaasUrl = config.paths.experiments;

    return new Promise((resolve) => {
        if (testId) {
            requestHeaders['X-Yandex-UAAS'] = 'testing';
            uaasUrl = url.format(
                Object.assign({}, url.parse(uaasUrl), {
                    pathname: null,
                    search: null,
                    query: {
                        'test-id': testId
                    }
                })
            );
        }

        request(
            {
                url: uaasUrl,
                timeout: 160,
                headers: requestHeaders
            },
            function(error, response) {
                const experiments = {
                    flags: [],
                    boxes: []
                };

                let flagsHeader;

                let experimentBoxes;

                if (!error && response && response.statusCode === 200 && response.headers['x-yandex-expflags']) {
                    console.log(
                        'INFO broker',
                        '[' + new Date() + ']',
                        xForwardedFor,
                        userAgent,
                        'Experiment status header was: ',
                        response.headers['x-yandex-expflags']
                    );

                    flagsHeader = response.headers['x-yandex-expflags'];
                    experimentBoxes = response.headers['x-yandex-expboxes'] || '';

                    flagsHeader.split(',').forEach(function(header) {
                        let buffer;

                        let parsed;

                        let flags;

                        try {
                            buffer = Buffer.from(header, 'base64');
                            parsed = JSON.parse(buffer.toString());

                            if (Array.isArray(parsed) && parsed[0] && parsed[0].HANDLER === 'PASSPORT') {
                                flags =
                                    (parsed[0].CONTEXT &&
                                        parsed[0].CONTEXT.PASSPORT &&
                                        parsed[0].CONTEXT.PASSPORT.flags) ||
                                    [];

                                experiments.flags = experiments.flags.concat(flags);
                            }
                        } catch (e) {
                            console.error(
                                'WARN broker error',
                                '[' + new Date() + ']',
                                xForwardedFor,
                                userAgent,
                                'Reading experiment status was not "ok": ',
                                e
                            );
                        }
                    });

                    experiments.boxes = experimentBoxes.split(';');
                }

                if (flagId) {
                    experiments.flags.push(flagId);
                }

                return resolve(experiments);
            }
        );
    });
};

module.exports = (req, res, next) => {
    if (typeof res.locals.experiments !== 'undefined') {
        return next();
    }

    return getYaExperimentsInfoPromise(req)
        .then((experiments) => {
            const flags = experiments.flags;
            const boxes = experiments.boxes || [];

            res.locals.experiments = {
                flags,
                boxes
            };

            return next();
        })
        .catch((error) => {
            console.error('WARN broker error', '[' + new Date() + ']', 'getYaExperimentInfo', error);
        });
};
