const domainRegExp = /^(?:.*\.)?yandex\.(.*)$/;

exports.getTld = (hostname) => {
    const domain = domainRegExp.exec(hostname);

    return (domain !== null && domain[1]) || 'ru';
};

exports.errorMsg = {
    InternalError: 'internal-exception',
    SessionInvalidError: 'integrity-data',
    YandexuidInvalidError: 'integrity-data',
    UserDeniedError: 'not_granted_access',
    ConsumerUnknownError: 'consumer-unknown',
    ProviderUnknownError: 'provider-unknown',
    ApplicationUnknownError: 'application-unknown',
    DisplayInvalidError: 'display-unknown',
    RetpathInvalidError: 'retpath-invalid',
    HostInvalidError: 'internal-exception',
    CommunicationFailedError: 'communication-failed',
    RateLimitExceededError: 'rate-limit',
    AuthorizationRequiredError: 'authorization-required',
    AccessTokenError: 'integrity-data',
    PkceCodeInvalidError: 'action_if_anonymous-invalid',
    PkceMethodInvalidError: 'action_if_anonymous-invalid',
    DatabaseFailedError: 'internal-exception'
};
