const DEFAULT_WIDTH = 650;
const DEFAULT_HEIGHT = 350;

export const getWindowSizeByProvider = (provider) => {
    const user = navigator.userAgent;

    let width = DEFAULT_WIDTH;

    let height = DEFAULT_HEIGHT;

    switch (provider) {
        case 'sberbank':
            width = 1024;
            height = 980;
            break;
        case 'gg':
            width = 430;
            height = 690;
            break;
        case 'mr':
            width = 448;
            height = 380;
            break;
        case 'ig':
            width = 442;
            height = 400;
            break;
        case 'vk':
            width = 680;
            height = 460;
            break;
        case 'ok':
            width = 715;
            height = 400;
            break;
        case 'lf':
            width = 1016;
            height = 500;
            break;
    }

    if (user.match('OPR')) {
        height += 10;
    }
    if (user.match('Opera')) {
        height -= 25;
    }

    return {width, height};
};

export const getWindowPositionByProvider = (provider) => {
    const {width, height} = getWindowSizeByProvider(provider);
    const {availWidth, availHeight} = screen;
    const left = (availWidth - width) / 2;
    const top = (availHeight - height) / 2;

    return {left, top};
};

export const resizeWindowByProvider = (provider) => {
    const {width, height} = getWindowSizeByProvider(provider);
    const {left, top} = getWindowPositionByProvider(provider);

    window.moveTo(left, top);
    window.resizeTo(width, height);
};

export const resizeWindow = ({width = DEFAULT_WIDTH, height = DEFAULT_HEIGHT}) => {
    const {availWidth, availHeight} = screen;
    const left = (availWidth - width) / 2;
    const top = (availHeight - height) / 2;

    window.moveTo(left, top);
    window.resizeTo(width, height);
};

export const openWindow = (url, provider) => {
    const {width, height} = getWindowSizeByProvider(provider);
    const {left, top} = getWindowPositionByProvider(provider);

    window.open(
        url,
        'yandex-broker',
        `location=yes, resizable=yes, width=${width}, height=${height}, left=${left}, top=${top}`
    );
};

export const redirect = (location) => typeof window !== 'undefined' && (window.location = location);
