/* eslint-disable no-unused-vars */

const util = require('util');
const got = require('got');
const he = require('he');
const config = require('../../configs/current');
const locs = require('../../loc/social.json');
const getTld = require('../../lib/oldUtils').getTld;
const formBindView = require('../../views/formBind.js');
const errorView = require('../../views/authzInWebError.js');
const commonSetup = require('../commonSetup.js');
const {Validator} = require('express-json-validator-middleware');
const validator = new Validator({allErrors: true});
const {validate} = validator;
const schema = require('../schema.json');
const yr = require('yate/lib/runtime');
const client = require('../../lib/client');
const getPageContentByErrorCode = require('./common/getPageContentByErrorCode.js');
const generalError = require('./common/generalError.js');
const apiResponseError = require('./common/apiResponseError.js');

var csrf = require('csurf');
var csrfProtection = csrf({
    cookie: {
        httpOnly: true,
        secure: true
    }
});

exports.route = function(app) {
    app.get('/broker2/authz_in_web/:task_id/bind', this.bind);
};

exports.bind = [
    // TODO: validate({query: schema}),
    commonSetup,
    csrfProtection,
    (req, res, next) =>
        doRequest(req, res)
            .then(({body}) => {
                const {account_display_name, application_display_name, cancel_url, cookies, location, status} = body;

                if (cookies) {
                    res.append('Set-Cookie', cookies);
                }

                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }

                if (status === 'form_bind_agreement') {
                    const lang =
                        (req.langdetect && ['ru', 'en', 'uk', 'tr'].includes(req.langdetect.id) && req.langdetect.id) ||
                        'ru';
                    const loc = locs[lang];
                    const content = util.format(
                        loc.common['authz_in_web_need_confirm_content'],
                        `<strong>${he.escape(account_display_name.name)}</strong>`,
                        `<strong>${he.escape(application_display_name)}</strong>`
                    );

                    res.status(200).send(
                        yr.run('formBind', {
                            account_display_name,
                            application_display_name,
                            lang,
                            st_path: config.st_path,
                            windowHeight: 320,
                            windowWidth: 650,
                            i18n: loc,
                            errorTitle: loc.common['authz_in_web_need_confirm_title'],
                            closeButton: loc.common['button.cancel'],
                            continueButton: loc.common['button.continue'],
                            tld: getTld(req.hostname),
                            content,
                            csrfToken: req.csrfToken(),
                            cancel_url,
                            uatraits: req.uatraits || {}
                        })
                    );
                }
            })
            .catch(next),
    apiResponseError,
    generalError
];

function doRequest(req, res) {
    const {
        params: {task_id},
        query,
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id, track}
    } = req;

    return client.call('/authz_in_web/bind/submit', {
        method: 'POST',
        form: true,
        query,
        body: {
            task_id,
            track,
            Session_id,
            user_ip
        }
    });
}
