/* eslint-disable no-unused-vars */

const got = require('got');
const config = require('../../configs/current');
const locs = require('../../loc/social.json');
const getTld = require('../../lib/oldUtils').getTld;
const spinView = require('../../views/spin.js');
const bindView = require('../../views/bind.js');
const captchaView = require('../../views/captcha.js');
const errorView = require('../../views/error.js');
const indexView = require('../../views/index.js');
const commonSetup = require('../commonSetup.js');
const {Validator} = require('express-json-validator-middleware');
const validator = new Validator({allErrors: true});
const {validate} = validator;
const schema = require('../schema.json');
const yr = require('yate/lib/runtime');
const client = require('../../lib/client');
const getPageContentByErrorCode = require('./common/getPageContentByErrorCode.js');
const generalError = require('./common/generalError.js');
const apiResponseError = require('./common/apiResponseError.js');

var csrf = require('csurf');
var csrfProtection =
    process.env.RUNNER === 'jest'
        ? (req, res, next) => next()
        : csrf({
              cookie: true
          });

exports.route = function(app) {
    // app.use(config.path + '/authz_in_web', pino);
    app.post('/broker2/authz_in_web/:task_id/bind', this.bind);
};

exports.bind = [
    // TODO: validate({query: schema}),
    commonSetup,
    csrfProtection,
    (req, res, next) => {
        return doRequest(req, res)
            .then(({body: {status, location, cookies}}) => {
                if (cookies) {
                    res.append('Set-Cookie', cookies);
                }

                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }
            })
            .catch(next);
    },
    apiResponseError,
    generalError
];

function doRequest(req, res) {
    const {
        params: {task_id},
        query,
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id, track}
    } = req;

    return client.call('/authz_in_web/bind/commit', {
        method: 'POST',
        form: true,
        query,
        body: {
            task_id,
            track,
            Session_id,
            user_ip
        }
    });
}
